import re
import random
import math
from functools import reduce
from textwrap import wrap
import shutil
import os
import sys
import subprocess
import networkx as nx
import matplotlib.pyplot as plt
########################################################################################§##################################
# Paths to where ./BigraphER and rpl-udp folder are

outPathCooja = "./contiki-ng/examples/rpl-udp/S_1/"

outPathBigraph = "./BigraphER/"
########################################################################################§##################################

## Generate the random topology:
maxX = 100.00
maxY = 100.00
wirelessRange = 100.00

num = input("Enter the number of nodes  ")
numNodes = int(num)

def distance(m1, m2):
    sqr=(m1["x"]-m2["x"])**2 + (m1["y"]-m2["y"])**2
    if sqr > 0:
        return math.sqrt(sqr)
    return 0

def overlaps(m1, m2):
    return distance(m1,m2) <= wirelessRange

def moteXML(m):
   return """
      <mote>
        <breakpoints />
        <interface_config>
          org.contikios.cooja.interfaces.Position
          <x>{}</x>
          <y>{}</y>
          <z>0.0</z>
        </interface_config>
        <interface_config>
          org.contikios.cooja.mspmote.interfaces.MspClock
          <deviation>1.0</deviation>
        </interface_config>
        <interface_config>
          org.contikios.cooja.mspmote.interfaces.MspMoteID
          <id>{}</id>
        </interface_config>
        <motetype_identifier>z12</motetype_identifier>
      </mote>
    """.format(m["x"], m["y"], m["id"])

def generateXML(motes):
    xml = ""
    for m in motes:
        xml += moteXML(m)
    finalCoojaCode=xml.replace("z12", "z11", 1)
    return finalCoojaCode

def toSvg(motes, edges):
    svg = ""
    for m in motes:
        svg += "<circle cx=\"{}\" cy= \"{}\" r=\"3\" fill=\"red\"/>".format(m["x"], m["y"], wirelessRange)
        svg += "<circle cx=\"{}\" cy= \"{}\" r=\"{}\" fill=\"none\" stroke=\"black\"/>".format(m["x"], m["y"], wirelessRange)
    for (i,j) in edges:
        svg += "<line x1=\"{}\" x2=\"{}\" y1=\"{}\" y2=\"{}\" stroke=\"blue\"/>"    .format(motes[i]["x"], motes[j]["x"], motes[i]["y"], motes[j]["y"])
        return svg

    
def generateSVG(motes, edges):
    return """
    <svg height=\"{}\" width=\"{}\">
    {}
    </svg>
    """.format(maxX*20, maxY*20, toSvg(motes,edges))

motes = []
nextId = 1
mId = 0
for m in range(0, numNodes):
    x = random.randint(-100,maxX)
    y = random.randint(-100,maxY)
    motes.append({"x": x, "y": y, "id":nextId})
    nextId += 1
    mId += 1

    
edges = []

for i in range(0, numNodes):
    for j in range(0, numNodes):
        if i == j: continue
        if overlaps(motes[i], motes[j]): edges.append((i,j))

        
def removeDir(acc, x):
    (i,j) = x
    if (j,i) in acc:
        return acc
    else:
        acc.append((i,j))
        return acc


edgesList=[]
for i,j in edges:
     edgesList.append((i+1,j+1))
  

# Generate the network:
HTopology = nx.DiGraph(edgesList)
graphNodes=HTopology.number_of_nodes()
f1 = plt.figure()
nx.draw(HTopology,  ax=f1.add_subplot(111), with_labels=True, )
f1.savefig("Topology_1.jpg")

if not HTopology.has_node(1) or not nx.is_strongly_connected(HTopology) or not graphNodes == numNodes:
  print( "The generated topology does not meet the requirements. Try again to generate another topology")
  sys.exit()

########## Generate bigraphER model format (.big file) ###############
    
#1. Physical Part
    
edgesBiDir = reduce(removeDir, edges, [])
physicalNodes = {}
for n in range(0, numNodes):
    physicalNodes[n] = []

 
nextLink = 0
for e in edgesBiDir:
    (i,j) = e
    l = "l" + str(nextLink)
    physicalNodes[i].append(l)
    physicalNodes[j].append(l)
    nextLink += 1

    
def outputPhysical(nodes):
    def outputPNode(n):
        res = ""
        first = True
        for l in nodes[n]:
            if first:
                res += "PLink{{{}}}.Idle".format(l)
                first = False
            else:
                res += " | PLink{{{}}}.Idle".format(l)
        return res
    res = ""
    first = True
    for n in nodes:
        if first:
            res += "PNode{{{}}}.({})".format("n" + str(n), outputPNode(n))
            first = False
        else:
            res += " | PNode{{{}}}.({})".format("n" + str(n), outputPNode(n))
    return res

#2. Routing Part
routingNodes={}
def outputRouting(nodes):
   result = ""
   first = True
   for n in range(0,numNodes):
       if first:
         result += "Node{{{}}}.(ID(\"{}\") | Rank.Val(0) | GenToken)".format("n" + str(n),  str(n+1))
         first = False
       else:
         result += " | Node{{{}}}.(ID(\"{}\") )".format("n" + str(n), str(n+1))
   return result


#3. Clousers Line
def outputClouser(nodes):
    def outputLinks(n):
        res = ""
        
        for l in nodes[n]:
            
                res += "{}".format(  " /" + l)
        return res
    
    res = ""
    
    for n in nodes:
        
            res += " /{}{}".format("n" + str(n), outputLinks(n))
           
    if nextLink <= 9:
        splitClousers=wrap(res,3)
    if nextLink <= 99:
        splitClousers=wrap(res,4)
    else:
        splitClousers=wrap(res,5)

    clouserLine=""

    finalClouserLine=""

    for i in splitClousers:
        if (i in clouserLine):
           pass
        else:
           clouserLine=clouserLine+i        
    return clouserLine



####################################################################################

# Create initial state block, and then update .big template with it:


bigraphERInitState="big autoGenerated = " + "\n" + outputClouser(physicalNodes) + " ( \n Physical.( " + outputPhysical(physicalNodes) + ") || \n Routing.( " + outputRouting(routingNodes) + ") \n );"


updatebigraphERInitState=bigraphERInitState.replace("()", "1")


with open("The_Experiment_Templates/RPL_Bigrapher_Template.big", "r") as tf:
   templateContents = tf.read()

   contents = []
   for ind, val in enumerate(templateContents.split('\n')):
     contents.append(val)
     if val == '#Initial State End':
       contents.insert(-2, updatebigraphERInitState)

with open("AutoBigraphER_1.big", "w") as ntf:
   ntf.write("\n".join(contents))



########################################################################

########## Generate Cooja model format (.csc file) ###############
     

#Insert motes list <mote>id</mote> in the original file and generate the initial Auto cooja file

finalCode=""
for m in range(0, numNodes):
    finalCode += "      <mote>{}</mote>\n".format(m)
    m += 1

with open("The_Experiment_Templates/RPL_Cooja_Template.csc", "r") as tcf: 
    preContents = tcf.read()
    finalFile = []
    for ind, val in enumerate(preContents.split('\n')):
     finalFile.append(val)
     if val == '      <showRadioRXTX />':
       finalFile.insert(-2, finalCode)

with open("AutoCooja_1.csc", "w") as ncf:   
    ncf.write("\n".join(finalFile))



linkNum=""
linkNum += "links: {}".format(numNodes)

# Update the initial Auto cooja file with auto motes specification 
with open('AutoCooja_1.csc', 'r+') as cf:
   coojaCode = cf.read()
   ncojjaCode = re.sub(r'<mote>(.*)here', generateXML(motes) ,coojaCode, flags=re.M|re.DOTALL)
   ncojjaCode=ncojjaCode.replace("links: ?", linkNum)
   cff = open("AutoCooja_1.csc", "w")
   cff.write(ncojjaCode)
   cff.close()


########################################################################



# Copy generated files into the correct folders ( BigraphER.exe and Contiki-ng ) to run them :

shutil.copyfile("AutoCooja_1.csc", outPathCooja + "AutoCooja_1.csc")

shutil.copyfile("AutoBigraphER_1.big", outPathBigraph + "AutoBigraphER_1.big")


# Save the topology details in a text file for reference:

with open('TopologiesDocument_1.txt', 'w') as td:
    td.write(" \n\n ###################### Topology_1 # details:  ###################### \n\n Number of nodes: %s \n Number of links:  %s \n Density =  %s \n Edges list: %s \n ################################################################## \n\n " % ( numNodes, nextLink, nx.density(HTopology), edgesList))

print("\n\n.big and .csc files are generated")
